
**************************************************************************************************************************************************
******************* Code for 'Doing Less with Less: Capital Misallocation, investment and the prodcutivty slowdown in Australia *******************
***************************************************** Code for  ******************************************************************

**************************************************DATE: AUG 2022 ******************************************************************************
**************************************************** AUTHOR: Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*00. Preliminaries and globals
*01. Intiail data merge of files
*02 Merge outside data
*03 Variable constrcution




************* 01. Intiail data merge of files**********

use "$data\bit.dta", clear


compress

merge m:1 id tsid using "$data\frame.dta", keepusing(latest_anzsic06 latest_sisca08 x_state)
keep if _merge == 3
drop _merge

g fyear = tsid+2000

egen firmid = group(id)

g industry = latest_anzsic06*1
drop latest_anzsic06

* Remove missing or undefined industries
drop if industry == .
drop if industr == 9999


************** ANZSIC DIVISIONS ************** 

g division = "A" if industry < 600
replace division = "B" if industry > 599 & industry < 1100
replace division = "C" if industry > 1099 & industry < 2600
replace division = "D" if industry > 2599 & industry < 3000
replace division = "E" if industry > 2999 & industry < 3300
replace division = "F" if industry > 3299 & industry < 3900
replace division = "G" if industry > 3899 & industry < 4400
replace division = "H" if industry > 4399 & industry < 4600
replace division = "I" if industry > 4599 & industry < 5400
replace division = "J" if industry > 5399 & industry < 6200
replace division = "K" if industry > 6199 & industry < 6500
replace division = "L" if industry > 6599 & industry < 6800
replace division = "M" if industry > 6799 & industry < 7100
replace division = "N" if industry > 7199 & industry < 7400
replace division = "O" if industry > 7499 & industry < 8000
replace division = "P" if industry > 7999 & industry < 8300
replace division = "Q" if industry > 8399 & industry < 8800
replace division = "R" if industry > 8899 & industry < 9300
replace division = "S" if industry > 9399 & industry < 9999

*Central banking not relevant
drop if industry == 6210

** REmove financial, government and not for ptrofits
drop if latest_sisca08==.
drop if latest_sisca08 == 0
drop if latest_sisca08 >2999 & latest_sisca08 < 3999
drop if latest_sisca08 > 4999

*Get rid of fin outside of te finacnial sector
drop if latest_sisca08 >1999 & latest_sisca08 < 2999 & division != "K"
*Get rid of government related siscas
drop if latest_sisca08 == 2110 | latest_sisca08 == 2301

compress

merge 1:1 tsid id using "$data\payg.dta", keepusing(fte hcnt)
drop if _merge == 2
drop _merge 


save "$data\bit_payg_pnl.dta", replace 


********* 03 Variable constrcution

use "$data\bit_payg_pnl.dta", clear


* REmove non-market and finance sectors
drop if division == "K" | division == "Q" | division == "P" | division == "O"



*Import import price deflators
merge m:1 fyear division using "$data\IPDs.dta"
keep if _merge == 3
drop _merge 


compress

ds c_* i_* t_* p_*
local vars `r(varlist)'
** For relevant variable, set missing to zero so can add across busines types. scale down for ease
foreach var in `vars' {
	replace `var' = 0 if `var' ==.
	replace `var' = `var'/1000000
}

** Define variables summed across businsss type
g income_tot = c_totlinc+i_totbusin+ t_totbuspp+ t_totbusnp+ p_totbuspp+ p_totbusnp
g leaextot = c_leaexpau + c_leaexpos+p_leaextot + t_leaextot + i_leaextot 
g intextot = c_intexpau + c_intexpos + p_intextot + t_intextot + i_intexpau + i_intexpos
g royextot = c_royexpos + c_royexpau + p_royextot + t_royextot


foreach var in costsale extnlabr superann baddebts rentexps deprexps totlexps   totlwage { 
	g `var' = c_`var' + t_`var' + i_`var' + p_`var'
}


foreach var in currasst totlasst { 
	g `var' = c_`var' + t_`var' + p_`var'
}

** Capital stock is non-curr assets
g k_bit = totlasst- currasst


** Different potential varaible cost measures. presered is 2
g variable = costsale
g variable1 = totlexps - deprexps-rentexps-leaextot-baddebts -intextot-extnlabr-royextot
g variable2 = totlexps - deprexps-rentexps-leaextot-baddebts -intextot-extnlabr-royextot-totlwage-superann
*g variable3 = totlexps - deprexps-rentexps-leaextot-baddebts -intextot-extnlabr-royextot-totlwage-superann - motrexps

g labour = totlwage+superann

** Different potential fixed cost metrics - prefered is 2
g fixed = totlexp-variable
g fixed1 = totlexp-variable1
g fixed2 = totlexp-variable2-labour


** Construct measures needed for PIM simiilair to above - investment, termiation value, depreciation
* code left out de to changes in variable names, but folows same logic as above

drop c_* p_* i_* t_*


compress

save "$data\full_prod_bit.dta" , replace

